<?php
	#Treballant amb mètodes màgics.
	# https://www.php.net/manual/es/language.oop5.magic.php
	# https://diego.com.es/metodos-magicos-en-php
	#
	class cilindre {
		
		private $radi;
		private $longitud;
		
		private function volum(){
			return $this->longitud * $this->radi * $this->radi * M_PI;
 		}	
		
		private function area(){
			return ((2 * M_PI * $this->radi * $this->longitud) + (M_PI * $this->radi**2));
 		}
 		
 		public function mostra_resultats(){
			return array($this->area(),$this->volum());  
		}
				
		public function __construct($r,$l){
			$this->radi = $r;
			$this->longitud = $l;
		}
		
		# __get permet accedir a propietats(atributs) private o protected des de fora de l'objecte
		public function __get($prop){
			if(property_exists($this,$prop)){
				return $this->$prop;
			}
			else{
				return -1;
			}		
		}
		
		# __set permet accedir a propietats(atributs) private o protected des de fora de l'objecte per modifcar-los o crear-los 
		public function __set($prop,$valor){
			if(property_exists($this,$prop)){
				$this->$prop=$valor;
			}
		}
		
		# If a class implements __call(), then if an object of that class is called with a method that doesn't exist __call() is called instead. 
		# https://www.php.net/manual/es/language.oop5.overloading.php#object.call
		public function __call($metode,$arguments){
			$missatge = "Has fet una crida al mètode: ".$metode." amb els arguments:";
			foreach ($arguments as $arg) {
				$missatge.=" $arg";
			}
			echo $missatge.". Aquest mètode no existeix<br>";
		}
		
			
	}
	
	$cil = new cilindre(5,10); #utilitzant __contruct
	echo $cil->area_cilindre($cil->radi,$cil->longitud);#utilitzant __call	i __get
	$cil->longitud=7; #utilitzant __set
	echo "La nova longitud és: ".$cil->longitud."<br>"; #utilitzant __get
	$res = $cil->mostra_resultats();
	echo "Làrea del cilindre és: ".number_format($res[0],2)." m^2 i el volum és: ".number_format($res[1],2)." m^3<br>";
?>
	
	
