<?php
	#
	# Instal·la el paquet php-pdf per aconseguir el fitxer fpdf.phpa.
	# Dins del fitxer fpdf.php està definida la classe FPDF.
	# La classe FPDF té mètodes i atributs per poder generar fitxers PDF.
	# Caldrà incloure fpdf.php amb l'ordre require. És com fer un include de C.
	#
	require "fpdf.php";
	
	abstract class Formes {
		
		#Informació sobre classes abstractes: 
		#1- Una classe abstracta és un classe que té com a mínim un mètòde abstracte
		#2- Una classe abstracta té al davant la paraula clau abstract
		#3- Una classe abstrancta NO pot ser instanciada. No es pot crear un objecte a partir d'una classe abstracta
		#4- Un mètode abstracte té al davant la paraula clau abstract, té declarat el mètode amb el seu nom però no està desenvolupat
		#5- A efectes d'herència, les classes filles han de desenvolupar obligatòriament els mètodes abstractes de la classe pare
		#6- A efectes d'herència, les classes filles han de mantenir els nom dels mètodes abstractes de la classe pare
		#7- Els modificadors d'accés dels mètodes implementats en les classes filles han de ser iguals o inferiors als de la classe pare
		#8- Els mètodes desenvolupats en les classes filles han de treballar amb un número igual o superior d'arguments que el de la classe pare
		#9- Les classes abstractes permeten millorar l'organització del programa. La classe abstracta permet crear una llista comuna de mètodes
		#   que han de tenir classes similars. Totes les classes filles estan obligades a desenvolupar els mètodes de la classe pare abstracta.
		#10- Dins d'una classe abstracta es pot definir i desenvolupar un mètode que no sigui abstracte.
		
		const PI = 3.1416;
		const DIR_PRINT="/var/www/html/obj";	
		
		abstract function __construct($num);
		abstract function assigna_dimensions($array_dimensions);	
		abstract function Volum();
				
		function printPDF($tipus,$dim,$volum,$forma){
			$cadena="La forma ".$forma;
			switch($tipus){
				case "Cub":
					$cadena=$cadena." de longitud ".$dim[0]." cm, té un volum de ".$volum." cm3";
					break;
				case "Piramide":
					$cadena=$cadena." de longitud ".$dim[0]." cm i altura ".$dim[1]." cm, té un volum de ".$volum." cm3";
					break;
				case "Cilindre":
					$cadena=$cadena." de radi ".$dim[0]." cm i altura ".$dim[1]." cm, té un volum de ".$volum." cm3";
					break;
				case "Esfera":
					$cadena=$cadena." de radi ".$dim[0]." cm, té un volum de ".$volum." cm3";					
					break;
				case "Con":
					$cadena=$cadena." de radi ".$dim[0]." cm i altura ".$dim[1]." cm, té un volum de ".$volum." cm3";
					break;
			}		
			echo $cadena."<br>";
			$cadena=utf8_decode($cadena);
			$pdf = new FPDF('P','mm','A4');
			$pdf->AddPage();
			$pdf->SetFont('Helvetica','',16);
			$pdf->Write(7,$cadena);
			$pdf->Output(self::DIR_PRINT."/".$forma.".pdf","F");
			return 0;
		}		
	}
	
	class Cub  extends Formes{
		private $long;
		public $forma;
		
		function __construct($num){
			$this->forma = get_class($this).$num;
		}
						
		function assigna_dimensions($array_dimensions){
			$this->long = $array_dimensions[0];						
		}
		
		function Volum(){
			return $this->long**3;
		}
	}
	
	class Piramide  extends Formes{
		private $long;
		private $alt;
		public $forma;
		
		function __construct($num){
			$this->forma = get_class($this).$num;
		}
				
		function assigna_dimensions($array_dimensions){
			$this->long = $array_dimensions[0];
			$this->alt = $array_dimensions[1];
		}
				
		function Volum(){
			return ($this->long**2 * $this->long)/3 ;
		}
	}
	
	class Cilindre  extends Formes{
		private $radi;
		private $alt;
		public $forma;
		
		function __construct($num){
			$this->forma = get_class($this).$num;
		}
				
		function assigna_dimensions($array_dimensions){
			$this->radi = $array_dimensions[0];
			$this->alt = $array_dimensions[1];
		}
						
		function Volum(){
			return self::PI * $this->radi**2 * $this->alt ;
		}
	}
	
	class Esfera  extends Formes{
		private $radi;
		public $forma;
		
		function __construct($num){
			$this->forma = get_class($this).$num;
		}
		
		function assigna_dimensions($array_dimensions){
			$this->radi = $array_dimensions[0];			
		}
		
		function Volum(){
			return (4/3) * self::PI * $this->radi**3;
		}
	}
	
	class Con extends Formes{
		private $radi;
		private $alt;
		public $forma;
		
		function __construct($num){
			$this->forma = get_class($this).$num;
		}
				
		function assigna_dimensions($array_dimensions){
			$this->radi = $array_dimensions[0];
			$this->alt = $array_dimensions[1];
		}
		
		function Volum(){
			return (1/3) * self::PI * $this->radi**2 * $this->alt ;
		}
	}
	#Exemple amb un cilindre
	$frm = new Cilindre(1);
	$dimensions=array(10,4);
	$frm->assigna_dimensions($dimensions);
	$frm->printPDF(get_class($frm),$dimensions,$frm->Volum(),$frm->forma);
	echo "<br>";
	#Exemple amb un cub
	$frm = new Cub(1);
	$dimensions=array(5);
	$frm->assigna_dimensions($dimensions);
	$frm->printPDF(get_class($frm),$dimensions,$frm->Volum(),$frm->forma);
	echo "<br>";
	#Exemple amb un altre cub
	$frm = new Cub(2);
	$dimensions=array(8);
	$frm->assigna_dimensions($dimensions);
	$frm->printPDF(get_class($frm),$dimensions,$frm->Volum(),$frm->forma);
	echo "<br>";
	#Exemple amb una piràmide
	$frm = new Piramide(1);
	$dimensions=array(4,3);
	$frm->assigna_dimensions($dimensions);
	$frm->printPDF(get_class($frm),$dimensions,$frm->Volum(),$frm->forma);
	echo "<br>";
?>
