<?php

class DB {
  private $pdo = null;
  private $stmt = null;
 
  function __construct(){
    try {
	  require 'config.php';	
	  $this->pdo = new PDO("mysql:host=$host;dbname=$bd",$user,$passwd);
      $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
      $this->pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);               
    } catch (Exception $ex) {
		 die($ex->getMessage());
	}
  }

  function __destruct(){
    if ($this->stmt!==null) $this->stmt = null;
    if ($this->pdo!==null) $this->pdo = null;
  }

  function select($sql){
    $result = false;
    try {
      $this->stmt = $this->pdo->prepare($sql);
      $this->stmt->execute();
      $result = $this->stmt->fetchAll();
    } catch (Exception $ex) {
		 die($ex->getMessage());
	}
    $this->stmt = null;
    return $result;
  }  
}
$bd = new DB();
?>
